#include <avr/io.h> 

#define ENABLE_A  (PORTA |=  0x04)  // LCD ENable Ǵ PORTA_Bit2=1;
#define DISABLE_A (PORTA &= 0xFB)   // LCD DIsable Ǵ PORTA_Bit2=0; 
#define ENABLE_B  (PORTB |=  0x04)  // LCD ENable Ǵ PORTA_Bit2=1;
#define DISABLE_B (PORTB &= 0xFB)   // LCD DIsable Ǵ PORTA_Bit2=0;
#define ENABLE_C  (PORTC |=  0x04)  // LCD ENable Ǵ PORTA_Bit2=1;
#define DISABLE_C (PORTC &= 0xFB)   // LCD DIsable Ǵ PORTA_Bit2=0;
#define ENABLE_D  (PORTD |=  0x04)  // LCD ENable Ǵ PORTA_Bit2=1;
#define DISABLE_D (PORTD &= 0xFB)   // LCD DIsable Ǵ PORTA_Bit2=0;

void init_PORT(void)
{
	DDRA = 0xFF;    // PORTA 
	PORTA= 0xFF;     // ʱ 
	DDRB = 0xFF;    // PORTA 
	PORTB= 0xFF;     // ʱ 
	DDRC = 0xFF;    // PORTA 
	PORTC= 0xFF;     // ʱ 
	DDRD = 0xFF;    // PORTA 
	PORTD= 0xFF;     // ʱ 
}

  
void wait_busy_flag(void)
{
	unsigned int i;
	
	for(i=0;i<10000;i++);
} 

  
void m_delay(unsigned int m) // ƾ
{
	unsigned int i, j;
	  
	for(i=0;i<m;i++)
	   for(j=0;j<2650;j++);  //16MHz : 1msec
}

void ddelay(unsigned int p)
{
	unsigned int i;

	for(i=0;i<p;i++);
}

void instruction_out(unsigned char b)//ɾ  Լ
{
	PORTA=b&0xF0;                    // 4BIT  

	ENABLE_A;                          //ENABLE
	DISABLE_A;                         //DISABLE
	
	PORTA=(b<<4)&0xF0;               // 4BIT 
	
	ENABLE_A;                          //ENABLE
	DISABLE_A;                         //DISABLE
	
	//ɾ  Ϸɶ 
	m_delay(2);

	PORTB=b&0xF0;                    // 4BIT  

	ENABLE_B;                          //ENABLE
	DISABLE_B;                         //DISABLE
	
	PORTB=(b<<4)&0xF0;               // 4BIT 
	
	ENABLE_B;                          //ENABLE
	DISABLE_B;                         //DISABLE
	
	//ɾ  Ϸɶ 
	m_delay(2);

	PORTC=b&0xF0;                    // 4BIT  

	ENABLE_C;                          //ENABLE
	DISABLE_C;                         //DISABLE
	
	PORTC=(b<<4)&0xF0;               // 4BIT 
	
	ENABLE_C;                          //ENABLE
	DISABLE_C;                         //DISABLE
	
	//ɾ  Ϸɶ 
	m_delay(2);

	PORTD=b&0xF0;                    // 4BIT  

	ENABLE_D;                          //ENABLE
	DISABLE_D;                         //DISABLE
	
	PORTD=(b<<4)&0xF0;               // 4BIT 
	
	ENABLE_D;                          //ENABLE
	DISABLE_D;                         //DISABLE
	
	//ɾ  Ϸɶ 
	m_delay(2);

}


void char_out(unsigned char b)  //LCD ѹ  Լ
{
   
	PORTA=(b&0xF0)|0x01;        // 4BIT 
	
	ENABLE_A;                     //ENABLE
	DISABLE_A;                    //DISABLE 
	
	PORTA=((b<<4)&0xF0)|0x01;   // 4BIT 
	
	ENABLE_A;                     //ENABLE
	DISABLE_A;                    //DISABLE

   //ɾ  Ϸɶ 
    m_delay(2);

	PORTB=(b&0xF0)|0x01;        // 4BIT 
	
	ENABLE_B;                     //ENABLE
	DISABLE_B;                    //DISABLE 
	
	PORTB=((b<<4)&0xF0)|0x01;   // 4BIT 
	
	ENABLE_B;                     //ENABLE
	DISABLE_B;                    //DISABLE

   //ɾ  Ϸɶ 
    m_delay(2);

	PORTC=(b&0xF0)|0x01;        // 4BIT 
	
	ENABLE_C;                     //ENABLE
	DISABLE_C;                    //DISABLE 
	
	PORTC=((b<<4)&0xF0)|0x01;   // 4BIT 
	
	ENABLE_C;                     //ENABLE
	DISABLE_C;                    //DISABLE

   //ɾ  Ϸɶ 
    m_delay(2);
	
	PORTD=(b&0xF0)|0x01;        // 4BIT 
	
	ENABLE_D;                     //ENABLE
	DISABLE_D;                    //DISABLE 
	
	PORTD=((b<<4)&0xF0)|0x01;   // 4BIT 
	
	ENABLE_D;                     //ENABLE
	DISABLE_D;                    //DISABLE

   //ɾ  Ϸɶ 
    m_delay(2);
}


void string_out(unsigned char b, unsigned char *str) //ڿ  Լ
{
	unsigned int i=0;
	
	instruction_out(b);   //LCD ġ 
	
	do{
	    char_out(str[i]);
	  }
	while(str[++i]!='\0');   // NULL ڸ   
}


void init_LCD(void)                //LCDʱȭ ƾ
{   
	init_PORT();    // LCD  Ʈ ʱȭ

  	m_delay(15);                         
	            
	ddelay(600);			  
	instruction_out(0x28);   //LCD FUNCTION SET(16X2 LINE, 4 BIT, 5X8 DOT)            
    m_delay(2); 
    instruction_out(0x28);   //LCD FUNCTION SET(16X2 LINE, 4 BIT, 5X8 DOT)    
	m_delay(2);
	 
	 
	instruction_out(0x0C);   //LCD DISPLAY ON, CURSOR OFF, BLINK OFF 

	instruction_out(0x01);   //LCD CLEAR
	instruction_out(0x01);   //LCD CLEAR

	instruction_out(0x02);   //RETURN HOME
	
	 
	instruction_out(0x06);   //LCD ENTRY MODE SET
}

void main(void)
{
    unsigned char shift=0;

    init_LCD();
    m_delay(2);
    instruction_out(0x01);   // LCD .
	m_delay(2);
    string_out(0x80,"Welcome to Device Technology Company....");  // LCD ù° 
	m_delay(2);
    string_out(0xC0,"ATMEL_mega128!..POWERTIP_TFT-LCD........");  // LCD ι° 
	m_delay(2);	

	while(1)                              // 
    {
     /* for(shift=0;shift<30;shift++)   //16 shfitŰ  for
        { 
         instruction_out(0x1C);       //LCD SHFIT RIGHT  
         m_delay(20);               //shfitǴ ð 300msec           
        } */
      for(shift=0;shift<30;shift++)   //32 shfitŰ  for
        { 
            instruction_out(0x18);       //LCD SHFIT LEFT 
            m_delay(5);               //shfitǴ ð 
			         
        } 
		

      
    }
	            
    
}
