/*
   CodeGen(V0.0.1) by Embedded Holic  - Copyright (c) 2010 
   ******************************************************************
   * This program is automatically generated by CodeGen             *
   ******************************************************************
*/
typedef char INT8;
typedef int  INT16;
typedef long INT32;
typedef unsigned char UINT8 ;
typedef unsigned int  UINT16;
typedef unsigned long UINT32;
#include <avr/io.h>
#include <avr/interrupt.h>

/*---- SYSTEM Configuration --------*/
#define SYS_CLK 16000000
/*---- UART TX/RX operating Mode ---*/
#define UART_RX_POLL 0
#define UART_RX_INT  1
#define UART_TX_POLL 0
#define UART_TX_BUFFER_INT  1

#define UART_CH0  0
#define UART_CH1  1
#define STOP_BIT1  0
#define STOP_BIT1_5 1
#define STOP_BIT2  2
#define PARITY_NONE 0
#define PARITY_ODD  1
#define PARITY_EVEN  2
#define BAUD_4800  0
#define BAUD_9600  1
#define BAUD_19200 2
#define BAUD_38400 3
#define BAUD_57600  4
#define BAUD_115200 5
#define BAUD_500K   6
#define BAUD_1M     7
#define BAUD_250K   8

#define YES  1
#define NO  0
#define FAIL  -1
#define SUCCESS  0

/*
 *----------------------------------------------------
 * SYSTEM_CLOCK = 16000000 Hz(16.000000 MHz) 
 * BAUD=   4800 UX2=1 UBRR=  416 ERR= -0.080%
 * BAUD=   9600 UX2=0 UBRR=  103 ERR=  0.160%
 * BAUD=  19200 UX2=0 UBRR=   51 ERR=  0.160%
 * BAUD=  38400 UX2=0 UBRR=   25 ERR=  0.160%
 * BAUD=  57600 UX2=1 UBRR=   34 ERR= -0.794%
 * BAUD= 115200 UX2=1 UBRR=   16 ERR=  2.124%
 *-----------------------------------------------------*/
typedef struct _baud_tbl_t { 
 UINT16 ubrr; 
 UINT8 UX2;
} baud_tbl_t;
baud_tbl_t mcu_baud_tbl[9] = {
 {  416,1}, /* baud =    4800 */ 
 {  103,0}, /* baud =    9600 */ 
 {   51,0}, /* baud =   19200 */ 
 {   25,0}, /* baud =   38400 */ 
 {   34,1}, /* baud =   57600 */ 
 {   16,1}, /* baud =  115200 */ 
 {    1,0}, /* baud =  500K   */
 {    0,0}, /* baud =  1M     */
 {    3,0}, /* buad =  250K   */
};


/*
 * Function tx_char without interrupt mode 
 */
UINT8 rx_char0(void)
{
 while(!(UCSR0A & (1 << RXC))); 
 return UDR0 & 0xff;
}

/*
 * Function tx_char without interrupt mode 
 */
void tx_char0(UINT8 c)
{
 while(!(UCSR0A & (1 << UDRE1))); 
 UDR0 = c;
}

UINT8 rx_char1_if_any(void)
{
    UINT8 tmp;
    if((UCSR1A & (1 << RXC))) {
	    tmp = UDR1;
		return 1;
    }
    return 0;
}

UINT8 rx_char1(void)
{
 while(!(UCSR1A & (1 << RXC))); 
 return UDR1 & 0xff;
}

/*
 * Function tx_char without interrupt mode 
 */
void tx_char1(UINT8 c)
{
 while(!(UCSR1A & (1 << UDRE1))); 
 UDR1 = c;
}

int uart_init(int ch,int stop,int parity, int baud, int rx_intr,int tx_intr)
{


 if( ch == UART_CH0 )
 {
  UCSR0A = (mcu_baud_tbl[baud].UX2 << U2X);
  UCSR0B = 0;
  if(parity == PARITY_NONE)
   UCSR0C = 0 << UPM10;
  else if(parity == PARITY_ODD)
   UCSR0C = 3 << UPM10;
  else // Even parity
   UCSR0C = 2 << UPM10;

  UCSR0C |= 3 << 1; // 8 bits default
  UBRR0H = mcu_baud_tbl[baud].ubrr >> 8;
  UBRR0L = mcu_baud_tbl[baud].ubrr & 0xff;
  if(rx_intr) UCSR0B |= (1 << RXCIE1);
  if(tx_intr) UCSR0B |= (1 << UDRIE);
  UCSR0B |= (1 << RXEN0) | (1 << TXEN0);

  return 0;
 }
 else if( ch == UART_CH1 )
 {
  UCSR1A = (mcu_baud_tbl[baud].UX2 << U2X);
  UCSR1B = 0;
  if(parity == PARITY_NONE)
   UCSR1C = 0 << UPM10;
  else if(parity == PARITY_ODD)
   UCSR1C = 3 << UPM10;
  else // Even parity
   UCSR1C = 2 << UPM10;

  UCSR1C |= 3 << 1; // 8 bits default
  UBRR1H = mcu_baud_tbl[baud].ubrr >> 8;
  UBRR1L = mcu_baud_tbl[baud].ubrr & 0xff;
  if(rx_intr) UCSR1B |= (1 << RXCIE1);
  if(tx_intr) UCSR1B |= (1 << UDRIE);
  UCSR1B |= (1 << RXEN1) | (1 << TXEN1);
  return 0;
 }
 return -1;
}


void my_putchar(UINT8 c)
{
 tx_char0(c);
 if(c == '\n') tx_char0('\r');
}


UINT8 my_getchar(void)
{
 UINT8 data;
 data = rx_char0();
 return data;
}

#include <stdio.h>
int sys_putchar(char c, FILE *file)

{

    tx_char0(c);

    if(c == '\n') tx_char0('\r');

}


FILE mystdout = FDEV_SETUP_STREAM(sys_putchar, NULL, _FDEV_SETUP_WRITE);
void get_cmd();
void exec_cmd();


int main(void)
{

  volatile float result;

 //SFIOR &= ~PUD;
 stdout = &mystdout;
 uart_init(UART_CH0,STOP_BIT1,PARITY_NONE,BAUD_9600,NO,NO);
 //uart_init(UART_CH1,STOP_BIT1,PARITY_NONE,BAUD_250K,NO,NO);

 printf("Hello Uart0 works at %d baud \n",9600);
 printf("monitor-128 $ ");
 while(1)
 {
 	get_cmd();
	exec_cmd();
	printf("monitor-128 $ ");
 }
}


struct {
	unsigned char cmd_buf[128];
	unsigned char idx;
} Cmd_buf;

#define JC_putchar  my_putchar
static int JC_getchar()
{
	signed char c;
    c = my_getchar();
	return c;		
}

static int JC_putChar(char c)
{
	JC_putchar(c);
}

static void JC_putString(char *s)
{
	while(*s) JC_putChar(*s++);
}

void get_cmd()
{
	int c;
	while(1)
	{
		c = JC_getchar();
		if(c == (int)-1) continue;
		if(Cmd_buf.idx >=  sizeof(Cmd_buf.cmd_buf) - 1) {
			Cmd_buf.cmd_buf[Cmd_buf.idx] = '\0';
			return;
		}
		else if(c == '\b'){
			if((Cmd_buf.idx > 0)){
				JC_putChar('\b'); JC_putChar(' '); JC_putChar('\b');
				Cmd_buf.idx --;
			}
		}
		else if(c == '\n' || c == '\r')
		{
			JC_putChar('\n'); JC_putChar('\r');
			Cmd_buf.cmd_buf[Cmd_buf.idx] = '\0';
			Cmd_buf.idx = 0;
			return;
		}
		else
		{
			Cmd_buf.cmd_buf[Cmd_buf.idx++] = c;
			JC_putChar(c);
		}
	}
}

#include <string.h>
#define NUM_ARGS	10
#define MAX_ARGS_LEN 20
#define JC_strcpy	strcpy
#define JC_strcmp	strcmp

int get_args(char *buf, char *av[])
{
	int	num, start, end;
	start = end = num = 0;
	while (1)
	{
//printf("start=%d end=%d buf[end]=%x num=%d\n",start,end,buf[end],num);
		if(buf[end] == '\0' || buf[end] == '\n' || buf[end] == '\r')
		{
			if(start != end)
			{
				JC_strcpy(av[num],buf+start);
				num ++;
				av[num] = 0;
				return num;
			}
			else
			{
				av[num] = 0;
				return num;
			}
		} 
		if(buf[end] != ' ' && buf[end] != '\t' ) {
			end ++;
		}
		else
		{
			buf[end] = 0;
			JC_strcpy(av[num],buf+start);
			num ++;
			end ++;
			start = end ;
		}
	}
	return 0;
}

unsigned char delay_1ms(unsigned char anchor)
{
    signed int delay;
	unsigned char cur,next;
	cur = anchor;
	delay = SYS_CLK / 1000;
	while(delay > 0)
	{
	    next = TCNT0;
		delay -= (next - cur) & 0xff;
		cur = next;
	}
	return cur;
}

delay_ms(unsigned int v)
{
    unsigned char start;
	start = TCNT0;
	while(v--) start = delay_1ms(start);
}

static char *av[NUM_ARGS];
static char  avbuf[NUM_ARGS][MAX_ARGS_LEN + 1];

void help();
void md(int ac, char *av[]);
void ms(int ac, char *av[]);
void led_test(int ac, char *av[]);
void fnd_test(int ac, char *av[]);
void read_temp_cmd(int ac, char *av[]);
void read_light(int ac, char *av[]);
void tone_generator(int ac, char *av[]);
void button_test(int ac, char *av[]);
void lcd_test(int ac, char *av[]);
void backlight(int ac, char *av[]);
void pin_set(int ac, char *av[]);
void motor_test(int ac, char *av[]);
#define NULL	(void*)0
struct {
	const char *cmd;
	const void (*fn)();
	const char *usage;
} cmd_tbl[] = {
	{"help",help,"Display the help message"},
	{"md"  ,md  ,"Memory dump"},
	{"ms"  ,ms	,"Memory set"},
	{"led"  ,led_test	,"LED test"},
	{"fnd"  ,fnd_test	,"FND test"},
	{"temp" ,read_temp_cmd	,"Temperature test(i2c)"},
	{"light",read_light 	,"CDS test(ADC0)"},
	{"tone", tone_generator, "TONE Generator"},
	{"button",button_test, "BUTTON test"},
	{"lcd",lcd_test,"LCD test"},
	{"bl",backlight,"LCD backlight test"},
	{"pin",pin_set,"PIN Set test"},
	{"motor",motor_test,"MOTOR test"},
	{NULL,  NULL,NULL}
};

void help()
{
	int i,j;
	printf("--------------< Supported Commands >------------------\n");
	printf("  CMD            Description\n");
	printf("------------------------------------------------------\n");
	for(i=0;;i++)
	{
		if(cmd_tbl[i].cmd == NULL) break;
		JC_putchar(' ');
		JC_putString(cmd_tbl[i].cmd);
		for( j = 0 ; j < 10 - strlen(cmd_tbl[i].cmd) ; j ++) JC_putchar(' ');
		JC_putString(cmd_tbl[i].usage);JC_putchar('\n');JC_putchar('\r');
	}
	printf("------------------------------------------------------\n");
}

void LCD_write_reg(unsigned int addr, unsigned int v);
unsigned char LCD_read_reg(unsigned int addr);

void md(int ac, char *av[])
{
    unsigned int addr;
	unsigned char data;
    if(ac == 2)
	{
	    addr = h_atoi(av[1]);
		data = LCD_read_reg(addr);
		printf("LCD rd addr = %x data = %x\n",addr,data);
	}
}

void ms(int ac, char *av[])
{
    unsigned int addr;
	unsigned int data;
    if(ac == 3)
	{
	    addr = h_atoi(av[1]);
		data = h_atoi(av[2]);
		LCD_write_reg(addr,data);
		printf("LCD wr addr = %x data = %x\n",addr,data);
	}
}

void led_test(int ac, char *av[])
{
    UINT8 save,i;
    TCNT0 = 0;
    TCCR0 = 1; /* not scale the clock */
	save = DDRA;
	DDRA = 0xff;
    for( i = 0 ; i < 8 ; i ++)
	{
	    PORTA = (1 << i);
		delay_ms(1000);
	}
	DDRA = save;
	TCCR0 = 0;
}
/*
 * 7 segment LED PORTC.0 (low), PORTA.0-7(A-G,DP)
 *
 *            A
 *          F   B
 *            G
 *          E   C
 *            D       DP
 */
 #define _BIT(x) (1 << (x))
 #define LED_A  _BIT(0)
 #define LED_B  _BIT(1)
 #define LED_C  _BIT(2)
 #define LED_D  _BIT(3)
 #define LED_E  _BIT(4)
 #define LED_F  _BIT(5)
 #define LED_G  _BIT(6)
 #define LED_DP _BIT(7)
 unsigned char v_to_seg[10] = 
 {
 /* 0 */ LED_A | LED_B | LED_C | LED_D | LED_E | LED_F,
 /* 1 */         LED_B | LED_C ,
 /* 2 */ LED_A | LED_B | LED_G | LED_E | LED_D,
 /* 3 */ LED_A | LED_B | LED_G | LED_C | LED_D ,
 /* 4 */ LED_F | LED_G | LED_B | LED_C,
 /* 5 */ LED_A | LED_F | LED_G | LED_C | LED_D,
 /* 6 */ LED_A | LED_F | LED_E | LED_D | LED_C | LED_G,
 /* 7 */ LED_A | LED_B | LED_C,
 /* 8 */ LED_A | LED_B | LED_C | LED_D | LED_E | LED_F | LED_G,
 /* 9 */ LED_A | LED_B | LED_C | LED_D | LED_F | LED_G
 };

my_delay(int delay)
{
    volatile unsigned int i,j;
    for(j = 0 ; j < delay ; j ++)
    for( i = 0 ; i < 0xffff ; i ++);

}
void fnd_test(int ac, char *av[])
{
    UINT8 i,digits;
    DDRC = 0xff;
	DDRG = 0xf;
	digits = 0;
	for( i = 0 ; i < 100 ; i ++)
	{
	    if((UCSR0A & (1 << RXC))) {
		    if(UDR0 == 'q') 
		    break;
		}
	    PORTG = 1 << digits;
	    PORTC = v_to_seg[i%10];
		my_delay(10);
		digits++;
		if(digits >= 4) digits = 0;
	}
	printf("end of fnd test\n");
}



#define TEMP_I2C_ADDR 0x98 
#define TWI_PRESCALE_1     0
#define TWI_PRESCALE_4     1
#define TWI_PRESCALE_16    2
#define TWI_PRESCALE_64    3
/* TWCR : command register */
#define TWI_TWINT  (1 << 7) /* Write clears the TWINT flag */
#define TWI_ACKEN  (1 << 6)
#define TWI_START  (1 << 5)
#define TWI_STOP   (1 << 4)
#define TWI_ENABLE (1 << 2)
#define TWI_INT_EN (1 << 0)
#define START       0x08
#define MT_SLA_ACK  0x18
#define MT_DATA_ACK 0x28

#define TWI_STATUS_MASK (0xF8) /* Read +1, Write +0 */
#define MR_SLA_ACK  0x40
#define MR_DATA_ACK 0x50
#define MR_DATA_NACK 0x58

init_i2c()
{
    PORTD = 3; /* For Pull-up override value */
    SFIOR &= ~(1 << PUD); /* PUD */
    TWSR = TWI_PRESCALE_1;
    TWBR = 32; /* for 100 K Hz bus clock */
	TWCR = (1 << 6) | /* TWI Enable ACK bit */
	       (1 << 2) ; /* Enable TWI bus */
}

int read_temp()
{
    int data;
	volatile unsigned int loop_cnt;

	loop_cnt = 0;
    TWCR = TWI_START | TWI_TWINT | TWI_ENABLE;
	while(!(TWCR & TWI_TWINT))
	{
	    loop_cnt ++;
		if(loop_cnt >= 0x1000) return 0x4000;
	}; /* wait Start condition sent */
	if((TWSR & TWI_STATUS_MASK) != START) 
	{
	    /* Error */
		return 0x8000;
	}
	TWDR = TEMP_I2C_ADDR + 1;
	TWCR = TWI_TWINT | TWI_ENABLE;
	loop_cnt = 0;
	while(!(TWCR & TWI_TWINT)){
		loop_cnt ++;
		if(loop_cnt >= 0x1000) return 0x4001;

    }	    ; /* wait Start condition sent */
	if((TWSR & TWI_STATUS_MASK) != MR_SLA_ACK) 
	{
	    /* No ack flag */
		return 0x8000; 
	}
//	TWDR = cmd; /* Temp address to Command Reg*/
    TWCR = TWI_TWINT | TWI_ENABLE | TWI_ACKEN;
	loop_cnt = 0;
	while(!(TWCR & TWI_TWINT))
	{
		loop_cnt ++;
		if(loop_cnt >= 0x1000) return 0x4002;
	}; /* wait Start condition sent */
  	if((TWSR & TWI_STATUS_MASK) != MR_DATA_ACK) 
	{
	    /* No ack flag */
		return 0x8000; 
	}  
    data = TWDR << 8;
	TWCR = TWI_TWINT | TWI_ENABLE; /* SLA ACK not transmitted at last byte */
	loop_cnt = 0;
	while(!(TWCR & TWI_TWINT)){
		loop_cnt ++;
		if(loop_cnt >= 0x1000) return 0x4003;
	}; /* wait Start condition sent */
  	if((TWSR & TWI_STATUS_MASK) != MR_DATA_NACK) 
	{
	    /* No ack flag */
		return 0x8000; 
	}
	data |= TWDR;
	TWCR = TWI_TWINT | TWI_ENABLE | TWI_STOP;
	/* 9 bit defaults */
	return data >> 7;
}

void read_temp_cmd(int ac, char *av[])
{
    int temp;

	init_i2c();
	temp = read_temp();

    printf("TEMP = %d.%d\n\r",temp>>1,(temp & 1) ? 5 : 0);

}


#define ADC_AREF                  (0x0 << 6) 
#define ADC_AVCC_CAPON_AREF       (0x1 << 6) 
#define ADC_INTERN2_56_CAPON_AREF	(0x3 << 6) 

#define ADC_CLK_DIV_2		0
#define ADC_CLK_DIV_4		2
#define ADC_CLK_DIV_8		3
#define ADC_CLK_DIV_16	4
#define ADC_CLK_DIV_32	5
#define ADC_CLK_DIV_64	6
#define ADC_CLK_DIV_128	7

#define ADC_EN		0x80

/*
 *--------------------------------------------------------------
 * MODE : POLLING MODE
 * SYS_CLK = 16.000000 Mhz 
 * ADC_DIV = 8 (current fixed. if required update this value) 
 * ADC_CLK = 2.000000 Mhz 
 * ACT CH = 1
 * CONV_TIME : 
 * First  conv  = 25 Clocks    = 12.500000 uS
 * Normal conv  = 13 ADC CLOCK =  6.500000 uS
 * Per ADC channel conv time   =  6.500000 uS
 *--------------------------------------------------------------
 */
void init_adc(void)
{
	ADMUX = ADC_AREF;
	ADCSRA = ADC_EN | ADC_CLK_DIV_4;
}
unsigned int get_adc_value(UINT8 ch)
{
	UINT8	i,adcl;
	UINT16	v;
	ADMUX &= ~0x1F;
	ADMUX |= (ch & 0x7);
	ADCSRA |= 0x40;
	while( !(ADCSRA & (1 << ADIF))); 
	adcl = ADCL;
	v = (ADCH << 8) | adcl;
	return v;
}

void read_light(int ac, char *av[])
{
    init_adc();
	printf("Light ADC = %d\n",get_adc_value(0));
}


/*
 *  Buzzer tone OCR 
 *
 *               OCR
 *   
 *   = 64
 *               238
 *      #        224
 *               212
 *      #        200
 *               189
 *               178
 *      #        168
 *               158
 *               141
 *      #        133
 *               126
 *
 *   = 32
 *               238
 *      #        224
 *               212
 *      #        200
 *               189
 *               178
 *      
 */
#define DO  0    0
#define DO_S     1
#define RE       2
#define RE_S     3
#define MI       4
#define PA       5
#define PA_S     6
#define SOL      7
#define SOL_S    8
#define RA       9
#define RA_S     10
#define SI       11
#define DO_H     12
#define DO_H_S   13
#define RE_H     14
#define RE_H_S   15
#define MI_H     16
#define PA_H     17
struct tone_tbl_t {
    unsigned char prescale;
	unsigned char ocr;
} tone_tbl[] = 
{
    {64, 238},    /* DO */
    {64, 224},    /* DO_S */
	{64, 212},    /* RE */
    {64, 200},    /* RE_S */
	{64, 189},    /* MI */
	{64, 178},    /* PA */
	{64, 168},    /* PA_S */
	{64, 158},    /* SOL */
	{64, 149},    /* SOL_S */
	{64, 141},    /* RA */
	{64, 133},    /* RA_S */
	{64, 126},    /* SI */
	{32, 238},    /* DO_H */
	{32, 224},    /* DO_H_S */
	{32, 212},    /* RE_H */
	{32, 200},    /* RE_H_S */
	{32, 189},    /* MI_H */
	{32, 178}     /* PA_H */
};

void set_tone(unsigned char t_index)
{
   
    TCCR0 = TCCR0 & ~7; /* STOP the TIMER0 */ 
	TCNT0 = 0;
    if(tone_tbl[t_index].prescale == 64)
	{
	    TCCR0 |=  5; // 4;  
	}
	else /* presccaler = 32 */
	{
		TCCR0 |=  4; // 3;
	}
	OCR0 = tone_tbl[t_index].ocr;
}

void tone_generator(int ac, char *av[])
{
    UINT8 c;
    TCCR0 = (0 << COM01) | (1 << COM00) | ( 1 << WGM01) | (0 << WGM00) ;
	DDRB = 1 << 4;
    while(1)
	{
	    c = rx_char0();
		if(c == 'q')
		{
//		    TCCR0 &= ~7;
            TCCR0 = 0;
		    break;
		}
		set_tone(c - 'a');
	}

}

void button_test(int ac, char *av[])
{
    static UINT8 button0_state = 0;
	static UINT8 button1_state = 0;
	UINT8 c;
	while(1)
	{
		if(UCSR0A & (1 << RXC)) {
		    c = rx_char0();
			if(c == 'q') break;
		}
	    if((button0_state == 0) && !(PINE & (1 << 4)))
		{
		    button0_state = 1;
			printf("B0 pushed\n");
		}
	    if((button1_state == 0) && !(PINE & (1 << 5)))
		{
		    button1_state = 1;
			printf("B1 pushed\n");
		}
	    if((button0_state == 1) && (PINE & (1 << 4)))
		{
		    button0_state = 0;
		}
	    if((button1_state == 1) && (PINE & (1 << 5)))
		{
		    button1_state = 0;
		}

	}
}

void motor_test(int ac, char *av[])
{
    static UINT8 button1_state = 0;
	static UINT8 button2_state = 0;
	UINT8 forward = 0;
	PORTB = 7 << 5;   
	while(1)
	{
	    if(button1_state == 0 && !(PINE & ( 1 << 4)))
		{
		    button1_state = 1;
			PORTA ^= 1;
			if(forward)
			  PORTB = (0x2 << 6);
            else 
			  PORTB =  (0x1 << 6);
            forward = !forward;
		}
		else if(button1_state == 1 && (PINE & ( 1 << 4)))
		{
		    button1_state = 0;
		}
		if(button2_state == 0 && !(PINE & ( 1 << 5)))
		{
		    button2_state = 1;
			PORTA ^= 2;
		}
		else if(button2_state == 1 && (PINE & ( 1 << 5)))
		{
		    button2_state = 0;
		}
	}
}

UINT8 cmd_buf[1024];
UINT8 param_buf[16];


void tohigh(char *line)
{
	while(*line) {
		if(*line >= 'a' && *line <= 'z')
			*line -= ' ';
		line++;
	}
}
int hatoi(char *s)
{
	register int	t, n = 0;
	tohigh(s);
	while ((t = *s) != 0) {	
		if (t >= '0' && t <= '9') {
			t = t - '0';		
		} else {			
			t |= 0x20;
			if(t >= 'a' && t <= 'f') t = t - 'a' + 10;
			else if(t >= 'A' && t <= 'F') t = t - 'A' + 10;
			else 	return(n);
		}	
		n = (n << 4) + t;
		s++;
	}	
	return(n);
}

int my_atoi(char *s)
{
	register int	t, n = 0;
	tohigh(s);
	while ((t = *s) != 0) {	
		if (t >= '0' && t <= '9') {
			t = t - '0';		
		} 
		n = (n * 10) + t;
		s++;
	}	
	return(n);
}

h_atoi(char *s)
{
	if(s[0] == '0' && s[1] == 'x') return hatoi(s+2);
	return my_atoi(s);
}


void exec_cmd()
{
	int i,ac;
	for( i = 0 ; i < NUM_ARGS ; i ++) {
		av[i] = &avbuf[i][0];
	}
	ac = get_args(Cmd_buf.cmd_buf,av);

	for( i = 0 ; ; i ++)
	{
		if(cmd_tbl[i].cmd == NULL) break;
		if(!strcmp(av[0],cmd_tbl[i].cmd)) {
			(*cmd_tbl[i].fn)(ac,av);
		}
	}

}



unsigned char delay_us(int v)
{
    signed int delay;
	unsigned char cur,next;
	cur = TCNT0;
	delay = 16 * v;
	while(delay > 0)
	{
	    next = TCNT0;
		delay -= (next - cur) & 0xff;
		cur = next;
	}
	return cur;
}


/* This is for LCD TEST */
/* DB0 ~ DB7  : PORT A
   DB8 ~ DB15 : PORT C
   SPI_NCS : PORTB.0
   SPI_SCK : PORTB.1
   SPI_MOSI: PORTB.2
   SPI_MISO: PORTB.3
   MCU_nRD : PORTB.4
   MCU_nWR : PORTB.5
   LCD_RS  : PORTB.6
   MCU_nCS : PORTB.7
   MCU_NPENIRD : PORTD.0
   LCD_LED1    : PORTD.1
   LCD_LED2    : PORTD.2
   LCD_LED3    : PORTD.3
   MCU_RESET   : PORTD.4
*/

#define LCD_nRD  (1 << 4)
#define LCD_nWR (1 << 5)
#define LCD_RS  (1 << 6)
#define LCD_nCS (1 << 7)
#define TOUCH_PIN (1 << 4)
#define LCD_RESET (1 << 5)
#define LCD_LED   (1 << 6)

#define CLR_CS()      do {PORTB &= ~LCD_nCS;} while(0)
#define CLR_RS()      do {PORTB &= ~LCD_RS; } while(0)
#if 0
#define CLR_WR()      do {BUS_OUTPUT(); PORTB &= ~LCD_nWR;} while(0)
#else
#define CLR_WR()      do {PORTB &= ~LCD_nWR;} while(0)
#endif
#define CLR_RD()      do {PORTB &= ~LCD_nRD;} while(0)
#define CLR_RESET()   do {PORTD &= ~LCD_RESET;} while(0)
#if 0
#define HIGH_WR()     do {PORTB |=  LCD_nWR;BUS_INPUT();} while(0)
#else
#define HIGH_WR()     do {PORTB |=  LCD_nWR; } while(0)
#endif
#define HIGH_CS()     do {PORTB |=  LCD_nCS;} while(0)
#define HIGH_RS()     do {PORTB |=  LCD_RS; } while(0)
#define HIGH_RD()     do {PORTB |=  LCD_nRD;} while(0)
#define HIGH_RESET()  do {PORTD |=  LCD_RESET;} while(0)

#define OUT16(v)      do { PORTC = v >> 8; PORTA = v; } while(0)
#define BUS_INPUT()   do {DDRC = 0; DDRA = 0; } while(0)
#define BUS_OUTPUT()   do {DDRC = 0xff; DDRA = 0xff; } while(0)


void backlight(int ac, char *av[])
{
    DDRD = LCD_LED;
    if(ac == 2)
	{
	    if(!strcmp(av[1],"on"))
		{
		    PORTD &= ~LCD_LED;
		}
		else
		{
		    PORTD |= LCD_LED;
		}
	}
}

void pin_set(int ac, char *av[])
{
    DDRB = (LCD_nRD | LCD_nWR | LCD_RS | LCD_nCS);
	DDRD = (LCD_RESET | LCD_LED);
    if(ac == 3)
	{
	    if(!strcmp(av[1],"reset"))
		{
		    if(!strcmp(av[2],"on"))
			{
			    PORTD |= LCD_RESET;
			}
			else
			{
			    PORTD &= ~LCD_RESET;
			}
		}
	    if(!strcmp(av[1],"rd"))
		{
		    if(!strcmp(av[2],"on"))
			{
			    PORTB |= LCD_nRD;
			}
			else
			{
			    PORTB &= ~LCD_nRD;
			}
		}
	    if(!strcmp(av[1],"wr"))
		{
		    if(!strcmp(av[2],"on"))
			{
			    PORTB |= LCD_nWR;
			}
			else
			{
			    PORTB &= ~LCD_nWR;
			}
		}
	    if(!strcmp(av[1],"rs"))
		{
		    if(!strcmp(av[2],"on"))
			{
			    PORTB |= LCD_RS;
			}
			else
			{
			    PORTB &= ~LCD_RS;
			}
		}
	    if(!strcmp(av[1],"cs"))
		{
		    if(!strcmp(av[2],"on"))
			{
			    PORTB |= LCD_nCS;
			}
			else
			{
			    PORTB &= ~LCD_nCS;
			}
		}
	}
}
void LCD_write_ram(unsigned int v, unsigned  int num)
{
    unsigned int i;
//    PORTB = PORTB & ~(LCD_RS | LCD_nCS);
//    PORTB = PORTB & ~(LCD_RS | LCD_nCS);
//    PORTB = PORTB & ~(LCD_RS | LCD_nCS);
    CLR_CS();
	CLR_RS();
    OUT16(0x22);

	CLR_WR();
	HIGH_WR();
    HIGH_RS();

	for( i = 0 ; i < num ; i ++)
	{
	    OUT16(v);
		CLR_WR();
		HIGH_WR();
	}
	HIGH_CS();
}

void LCD_write_reg(unsigned int addr, unsigned int v)
{
	CLR_CS();
	OUT16(addr);
	CLR_RS();
	CLR_WR();
	HIGH_WR();
	HIGH_RS();

	OUT16(v);
	CLR_WR();
	HIGH_WR();
	HIGH_CS();


}


unsigned char LCD_read_reg(unsigned int addr)
{
    unsigned char v;
    CLR_CS();
	OUT16(addr);
	CLR_RS();
	CLR_WR();
//delay_ms(1);
	HIGH_WR();
	HIGH_RS();
	BUS_INPUT();
	CLR_RD();
	delay_us(1);
	v = PINA; // dummy read 
	HIGH_RD();
//	delay_ms(1);
	CLR_RD();
delay_us(1);
	v = PINA;
	HIGH_RD();
	HIGH_CS();
	BUS_OUTPUT();
	return v;
}

LCD_set_region(unsigned char sx, unsigned char sy, unsigned char ex, unsigned char ey)
{
    LCD_write_reg(0x3, sx);
	LCD_write_reg(0x5, ex);
	LCD_write_reg(0x7, sy);
	LCD_write_reg(0x9, ey);
}

init_lcd()
{
    int i,j;

    CLR_RESET();
    delay_ms(20);
	HIGH_RESET();
 //   PORTD &= ~LCD_LED;
    
    delay_ms(20);

    LCD_write_reg(0x60, 0x00);
    LCD_write_reg(0x61, 0x06);
    LCD_write_reg(0x62, 0x00);
    LCD_write_reg(0x63, 0xd9);
    LCD_write_reg(0x73, 0x70);

    LCD_write_reg(0x40, 0x20);
    LCD_write_reg(0x41, 0x41);
    LCD_write_reg(0x42, 0x41);
    LCD_write_reg(0x43, 0x01);
    LCD_write_reg(0x44, 0x34);
    LCD_write_reg(0x45, 0x02);
    LCD_write_reg(0x46, 0x08);
    LCD_write_reg(0x47, 0xd1);
    LCD_write_reg(0x48, 0x05);
    LCD_write_reg(0x50, 0x67);
    LCD_write_reg(0x51, 0x00);
    LCD_write_reg(0x52, 0x27);
    LCD_write_reg(0x53, 0x0b);
    LCD_write_reg(0x54, 0x83);
    LCD_write_reg(0x55, 0x0e);
    LCD_write_reg(0x56, 0x01);
    LCD_write_reg(0x57, 0x37);

    LCD_write_reg(0x1F, 0x03);
    LCD_write_reg(0x20, 0x02);
    LCD_write_reg(0x24, 0x1C);
    LCD_write_reg(0x25, 0x34);

    LCD_write_reg(0x23, 0x54);

    LCD_write_reg(0x18, 0x44);
    LCD_write_reg(0x1B, 0x44);
    LCD_write_reg(0x21, 0x01);
    LCD_write_reg(0x01, 0x00);
    LCD_write_reg(0x1C, 0x03);
    LCD_write_reg(0x19, 0x06);
    delay_ms(10);

    LCD_write_reg(0x17, 0x05);
    LCD_write_reg(0x26, 0x84);
    delay_ms(80);
    LCD_write_reg(0x26, 0xB8);
    delay_ms(80);
    LCD_write_reg(0x26, 0xBC);

    LCD_write_reg(0x02, 0x00);
    LCD_write_reg(0x03, 0x00);
    LCD_write_reg(0x04, 0x00);
    LCD_write_reg(0x05, 220-1); /* x-axis */
//    LCD_write_reg(0x05, 0xAF);
    LCD_write_reg(0x06, 0x00);
    LCD_write_reg(0x07, 0x00);
    LCD_write_reg(0x08, 0x00);
    LCD_write_reg(0x09, 176-1); /* y-axis */
//   LCD_write_reg(0x09, 0xDB);
/* X,Y coordinate redefine */
    LCD_write_reg(0x16, 0xA8);

}

void draw_ortho_line(unsigned int sX,unsigned int sY,unsigned int eX,unsigned int eY,unsigned int color)
{
    unsigned int num;
    LCD_write_reg(0x03, sX);
    LCD_write_reg(0x05, eX);
    LCD_write_reg(0x07, sY);
    LCD_write_reg(0x09, eY);
    num = (eX - sX + 1) * (eY - sY + 1);
//	delay_ms(4);
    LCD_write_ram(color,num);
}

#define RGB(r,g,b) \
    (( ((r) >> 3) << 11) | \
     ( ((g) >> 2) << 5) | \
     ( ((b) >> 3) << 0))

void init_ads7846();
void init_adc(void);
unsigned int get_adc_value(unsigned char  ch);
unsigned int x_12bit, y_12bit;// x_12bit(0-4095), y_12bit(0-4095)
unsigned int x_touch, y_touch;// x_touch(0-239), y_touch(0-319)
void lcd_test(int ac, char *av[])
{

    unsigned char v;
	int i;
    DDRA = 0xFF; /* PORT A input */
	DDRC = 0xFF; /* PORT C intput */

	DDRB = 0xff & ~(1 << 3) ; /* PORT B output ,MISO input(signal collison avoid*/
	DDRD = (LCD_RESET | LCD_LED); /* Reset and LED is output pin */
//	DDRD = (LCD_RESET | 0xe); /* Reset and LED is output pin */
    PORTB = 0xF0; /* MCU_nRD,MCU_nWR,LCD_RS, MCU_nCS all high */

    SFIOR |= PUD;
//	PORTD &= ~LCD_LED; /* LED all on */
	PORTD |= LCD_RESET | LCD_LED;  /* LCD reset */

    TCNT0 = 0;
    TCCR0 = 1; /* not scale the clock */
/* debug */


	init_lcd();
    PORTD  &= ~LCD_LED;
	while(0)
	{
	    for( i = 1 ; i < 256 ; i ++)
		{
//		    LCD_write_reg(0x22,i);
			v = LCD_read_reg(i);
			printf("i = %02x read = %02x\n",i, v);
			delay_ms(500);
		}
	}
 //   LCD_set_region(0, 0, 200, 100);
  //  LCD_write_ram(RGB(0,255,0), 20000-1);

#if 1
	while(1)
	{
		draw_ortho_line(0,0,219,176,RGB(255,0,0));
		delay_ms(1000);
		draw_ortho_line(0,0,219,176,RGB(0,255,0));
		delay_ms(1000);
		draw_ortho_line(0,0,219,176,RGB(0,0,255));
		delay_ms(1000);
	}
#else
    init_adc();
	PORTA = 0;
	while(0)
	{
	    unsigned int v;
		v = get_adc_value(7);
		printf("v = %x\n",v);
		delay_ms(1000);
	}

    init_ads7846();
	while(1)
	{

		Read_ADS7846_touch();
		printf("x = %04x y = %04x \n",x_12bit,y_12bit);
		delay_ms(1000);
	}
#endif
}

unsigned int input_ads7846(unsigned char command);
void init_ads7846()
{
    DDRB |= 1; /* PB0 output for SPI SS */
	SPCR = 0x51; /* 8 M / 16 = 500 Khz */
	SPSR = 0;
	input_ads7846(0);
}

unsigned char SPI_write(unsigned char data)
{
    SPDR = data;
	while(!(SPSR & 0x80));
	return SPDR;
}

unsigned int input_ads7846(unsigned char command)   /* input X, Y value from ADS7846 */
{
  unsigned int axis;

  PORTB &= ~1;

  SPI_write(command);
  axis = SPI_write(0x00);                               // read high 7 bit
  axis <<= 8;
  axis += SPI_write(0x00);                             // read low 5 bit
  axis >>= 3;

  PORTB |= 1;

  return axis;
}

#define ADS7846_CMD_X   0xD0
//0b11010000              // 12-bit X position measurement command
#define ADS7846_CMD_Y   0x90
// 0b10010000              // 12-bit Y position measurement command

void Read_ADS7846_touch(void)                   /* read X, Y average value from ADS7846 */
{
  unsigned char i;

  x_12bit = 0;                                                 // initial value
  y_12bit = 0;

  for(i = 0; i < 16; i++)                                     // read X, Y value by 16 times if -PENIRQ enable
    { if((PIND & TOUCH_PIN) == 0x00)                  // -PENIRQ = 0 ?
        x_12bit += input_ads7846(ADS7846_CMD_X);// if yes, measure X position
      else                                                       // if not, return with 0
        { x_12bit = 0;
           y_12bit = 0;
           break;
        }
      delay_us(10);

      if((PIND & TOUCH_PIN) == 0x00)                   // -PENIRQ = 0 ?
        y_12bit += input_ads7846(ADS7846_CMD_Y);// if yes, measure Y position
      else                                                      // if not, return with 0
        { x_12bit = 0;
           y_12bit = 0;
           break;
        }
      delay_us(10);
    }

  x_12bit >>= 4;                                             // calculate average for 16 times
  y_12bit >>= 4;
#if 0
  if(x_12bit <= x_touch_min)                          // convert to pixel x-axis value
    x_touch = 0;
  else if(x_12bit >= x_touch_max)
    x_touch = 239;
  else
    x_touch = (unsigned int)((float)(x_12bit - x_touch_min) * 239./(float)(x_touch_max - x_touch_min));

  if(y_12bit == 0)                                           // convert to pixel y-axis value
    y_touch = 0;
  else if(y_12bit <= y_touch_min)
    y_touch = 319;
  else if(y_12bit >= y_touch_max)
    y_touch = 0;
  else
    y_touch = 319 - (unsigned int)((float)(y_12bit - y_touch_min) * 319./(float)(y_touch_max - y_touch_min));
#endif
}



